% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlmMod.R
\name{dlmMod}
\alias{dlmMod}
\title{Create state space model of exDQLM from DLM}
\usage{
dlmMod(m)
}
\arguments{
\item{m}{An object of class "\code{dlm}" representing the DLM version of the desired exDQLM state space model. Only time-invariant \code{dlm} objects are currently considered.}
}
\value{
List containing only the components of \code{m} needed for the exDQLM state space model.
}
\description{
The function creates a state space model of an exDQLM from "\code{dlm}" object.
}
\examples{
library(dlm)
m = dlmModPoly(order=2,C0=10*diag(2)) + dlmModTrig(365,2,C0=10*diag(4))
model = dlmMod(m)

}
