% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topGen.R
\name{topGen}
\alias{topGen}
\title{Extract the top most species-rich genera}
\usage{
topGen(family, limit = 10, verbose = TRUE, save = FALSE, dir, filename)
}
\arguments{
\item{family}{Either one family name or a vector of multiple families that
is present in POWO.}

\item{limit}{A defined numerical value to limit the most diverse genera to be
selected within each plant family. The default is to select the top ten
richest genera.}

\item{verbose}{Logical, if \code{FALSE}, the search results will not be
printed in the console in full.}

\item{save}{Logical, if \code{FALSE}, the search results will not be saved on
disk.}

\item{dir}{Pathway to the computer's directory, where the file will be saved
provided that the argument \code{save} is set up in \code{TRUE}. The default
is to create a directory named \strong{results_topGen} and the searched results
will be saved within a subfolder named by the current date.}

\item{filename}{Name of the output file to be saved. The default is to create
a file entitled \strong{output}.}
}
\value{
Table in .csv format.
}
\description{
Produces a CSV file listing the top most diverse genera
of any target botanical family of flowering plants at
\href{https://powo.science.kew.org/}{Plants of the World Online (POWO)}.
}
\examples{
\donttest{
library(expowo)

topGen(family = "Lecythidaceae",
       limit = 10,
       verbose = TRUE,
       save = FALSE,
       dir = "results_topGen/",
       filename = "Lecythidaceae_top_ten")
}

}
\seealso{
\code{\link{POWOcodes}}
}
\author{
Debora Zuanny & Domingos Cardoso
}
