% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8.2-ens.R
\docType{methods}
\name{buildEnsemble}
\alias{buildEnsemble}
\alias{buildEnsemble,ExprsModel-method}
\alias{buildEnsemble,ExprsPipeline-method}
\title{Build Ensemble}
\usage{
buildEnsemble(object, ...)

\S4method{buildEnsemble}{ExprsModel}(object, ...)

\S4method{buildEnsemble}{ExprsPipeline}(object, colBy = 0, how = 0,
  gate = 0, top = 0)
}
\arguments{
\item{object}{An \code{\link{ExprsModel-class}} object.}

\item{...}{Additional \code{ExprsModel} objects to use in the ensemble.
Argument applies to \code{\link{ExprsModel-class}} method only.}

\item{colBy}{A character vector or string. Specifies column(s) to use when
filtering by classifier performance. Listing multiple columns will result
in a filter based on a performance metric equal to the product of those
listed columns.}

\item{how}{A numeric scalar. Arguments between 0 and 1 will impose
a threshold or ceiling filter, respectively, based on the raw value of
\code{colBy}. Arguments between 1 and 100 will impose a filter based on
the percentile of \code{colBy}. The user may also provide "midrange",
"median", or "mean" as an argument for these filters. Set \code{how = 0}
or \code{gate = 0}, to skip the threshold or ceiling filter,
respectively.}

\item{gate}{A numeric scalar. Arguments between 0 and 1 will impose
a threshold or ceiling filter, respectively, based on the raw value of
\code{colBy}. Arguments between 1 and 100 will impose a filter based on
the percentile of \code{colBy}. The user may also provide "midrange",
"median", or "mean" as an argument for these filters. Set \code{how = 0}
or \code{gate = 0}, to skip the threshold or ceiling filter,
respectively.}

\item{top}{A numeric scalar. Determines the top N models based on
\code{colBy} to include after the threshold and ceiling filters.
In the case that the \code{@summary} slot contains the column
"boot", this determines the top N models for each unique bootstrap.
Set \code{top = 0} to skip this subset.}
}
\value{
An \code{\link{ExprsEnsemble-class}} object.
}
\description{
Aggregates multiple classifiers into a single ensemble classifier.
}
\details{
The \code{\link{ExprsModel-class}} method:

Combine any number of \code{ExprsModel} objects into an ensemble. These models
 do not necessarily have to derive from the same \code{build} method. This
 method works identically to the \code{\link{conjoin}} \code{ExprsModel} method.

The \code{\link{ExprsPipeline-class}} method:

Build an ensemble from an \code{ExprsPipeline} object. This method works by
 calling \code{\link{pipeFilter}}, then aggregating those results into an ensemble.
 As an adjunct to this method, consider first combining multiple
 \code{ExprsPipeline} objects together with \code{\link{conjoin}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ExprsModel}: Method to build ensemble from \code{ExprsModel} objects.

\item \code{ExprsPipeline}: Method to build ensemble from \code{ExprsPipeline} objects.
}}
\seealso{
\code{\link{pipeFilter}}\cr
\code{\link{pipeUnboot}}\cr
\code{\link{plCV}}\cr
\code{\link{plGrid}}\cr
\code{\link{plGridMulti}}\cr
\code{\link{plMonteCarlo}}\cr
\code{\link{plNested}}
}

