% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7.2-plGrid.R
\name{plGrid}
\alias{plGrid}
\title{Perform High-Throughput Classification}
\usage{
plGrid(array.train, array.valid = NULL, top, how, fold = 10,
  aucSkip = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{array.train}{Specifies the \code{ExprsArray} object to use as training set.}

\item{array.valid}{Specifies the \code{ExprsArray} object to use as validation set.}

\item{top}{A numeric scalar or character vector. A numeric scalar indicates
the number of top features that should undergo feature selection. A character vector
indicates specifically which features by name should undergo feature selection.
Set \code{top = 0} to include all features. Note that providing a numeric vector
for the \code{top} argument will have \code{plGrid} search across multiple
top features. However, by providing a list of numeric vectors as the \code{top}
argument, the user can force the default handling of numeric vectors.}

\item{how}{A character string. Specifies the \code{\link{build}} method to iterate.}

\item{fold}{A numeric scalar. Specifies the number of folds for cross-validation.
Set \code{fold = 0} to perform leave-one-out cross-validation. Argument passed
to \code{\link{plCV}}. Set \code{fold = NULL} to skip cross-validation altogether.}

\item{aucSkip}{A logical scalar. Argument passed to \code{\link{calcStats}}.}

\item{verbose}{A logical scalar. Argument passed to \code{\link{exprso-predict}}.}

\item{...}{Arguments passed to the \code{how} method. Unlike the \code{build} method,
\code{plGrid} allows multiple parameters for each argument, supplied as a vector.
See Details.}
}
\value{
An \code{\link{ExprsPipeline-class}} object.
}
\description{
Trains and deploys multiple classifiers across a vast parameter search space.
}
\details{
\code{plGrid} will \code{\link{build}} and \code{\link{exprso-predict}} for
 each combination of parameters provided as additional arguments (\code{...}).
 When using \code{plGrid}, supplying a numeric vector as the \code{top}
 argument will train and deploy a classifier of each mentioned size for
 each combination of parameters provided in \code{...}. To skip validation set
 prediction, use \code{array.valid = NULL}. Either way, this function returns an
 \code{\link{ExprsPipeline-class}} object which contains the build parameters,
 classifier performances, and \code{ExprsModel} objects for all trained models.

\code{plGrid} will perform v-fold or leave-one-out cross-validation for the
 using \code{\link{plCV}}. The argument \code{fold} specifies the number
 of v-folds to use during cross-validation. Set \code{fold = 0} to perform
 leave-one-out cross-validation. This approach to cross-validation
 will work for \code{ExprsBinary} and \code{ExprsMulti} objects alike. The
 performance metric used to measure cross-validation accuracy is the
 \code{acc} slot returned by \code{\link{calcStats}}. Set \code{fold = NULL}
 to skip cross-validation altogether.

The use of \code{\link{plCV}} is most appropriate if the \code{ExprsArray}
 has not undergone any prior feature selection. However, it may also have a role
 as an unbiased guide to parameter selection when embedded in
 \code{\link{plGrid}}. If using cross-validation in lieu of an independent test
 set in the setting of one or more feature selection methods, consider using
 a more "sophisticated" form of cross-validation as implemented in
 \code{\link{plMonteCarlo}} or \code{\link{plNested}}.
}
\examples{
\dontrun{
require(golubEsets)
data(Golub_Merge)
array <- arrayEset(Golub_Merge, colBy = "ALL.AML", include = list("ALL", "AML"))
array <- modFilter(array, 20, 16000, 500, 5) # pre-filter Golub ala Deb 2003
array <- modTransform(array) # lg transform
array <- modNormalize(array, c(1, 2)) # normalize gene and subject vectors
arrays <- splitSample(array, percent.include = 67)
array.train <- fsStats(arrays[[1]], top = 0, how = "t.test")
pl <- plGrid(array.train, array.valid = arrays[[2]], how = "buildSVM",
             kernel = c("linear", "radial"), cost = 10^(-3:3), gamma = 10^(-3:3))
}
}
\seealso{
\code{\link{fs}}\cr
\code{\link{build}}\cr
\code{\link{doMulti}}\cr
\code{\link{exprso-predict}}\cr
\code{\link{plCV}}\cr
\code{\link{plGrid}}\cr
\code{\link{plGridMulti}}\cr
\code{\link{plMonteCarlo}}\cr
\code{\link{plNested}}
}
