% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_datatable.R
\name{as.datatable_widget}
\alias{as.datatable_widget}
\alias{as.datatable_widget.etable}
\alias{as.datatable_widget.with_caption}
\title{Create an HTML table widget for usage with Shiny}
\usage{
as.datatable_widget(data, ...)

\method{as.datatable_widget}{etable}(
  data,
  ...,
  repeat_row_labels = FALSE,
  show_row_numbers = FALSE,
  digits = get_expss_digits()
)

\method{as.datatable_widget}{with_caption}(
  data,
  ...,
  repeat_row_labels = FALSE,
  show_row_numbers = FALSE,
  digits = get_expss_digits()
)
}
\arguments{
\item{data}{a data object (result of \link{tables}/\link{fre}/\link{cro}).}

\item{...}{further parameters for \link[DT]{datatable}}

\item{repeat_row_labels}{logical Should we repeat duplicated row labels in
the every row? Default is FALSE.}

\item{show_row_numbers}{logical Default is FALSE.}

\item{digits}{integer By default, all numeric columns are rounded to one digit after
decimal separator. Also you can set this argument by option 'expss.digits'
- for example, \code{expss_digits(2)}. If it is NA than all
numeric columns remain unrounded.}
}
\value{
Object of class \link[DT]{datatable}
}
\description{
This is method for rendering results of \link{tables}/\link{fre}/\link{cro}
in Shiny. \code{DT} package should be installed for this
feature (\code{install.packages('DT')}). For detailed description of function
and its arguments see \link[DT]{datatable}.
}
\examples{
\dontrun{ 

data(mtcars)
mtcars = apply_labels(mtcars,
                      mpg = "Miles/(US) gallon",
                      cyl = "Number of cylinders",
                      disp = "Displacement (cu.in.)",
                      hp = "Gross horsepower",
                      drat = "Rear axle ratio",
                      wt = "Weight (1000 lbs)",
                      qsec = "1/4 mile time",
                      vs = "Engine",
                      vs = c("V-engine" = 0,
                             "Straight engine" = 1),
                      am = "Transmission",
                      am = c("Automatic" = 0,
                             "Manual"=1),
                      gear = "Number of forward gears",
                      carb = "Number of carburetors"
)

mtcars_table = mtcars \%>\% 
                 tab_cols(total(), am \%nest\% vs) \%>\% 
                 tab_cells(mpg, hp) \%>\% 
                 tab_stat_mean() \%>\% 
                 tab_cells(cyl) \%>\% 
                 tab_stat_cpct() \%>\% 
                 tab_pivot() \%>\% 
                 set_caption("Table 1. Some variables from mtcars dataset.")

library(shiny)
shinyApp(
    ui = fluidPage(fluidRow(column(12, DT::dataTableOutput('tbl')))),
    server = function(input, output) {
        output$tbl = DT::renderDataTable(
            as.datatable_widget(mtcars_table)
        )
    }
)
}
}
\seealso{
\link[htmlTable]{htmlTable} for knitting
}
