% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{info}
\alias{info}
\title{Provides variables description for dataset}
\usage{
info(x, stats = TRUE, frequencies = TRUE, max_levels = 10)
}
\arguments{
\item{x}{vector/factor/list/data.frame.}

\item{stats}{Logical. Should we calculate summary for each variable?}

\item{frequencies}{Logical. Should we calculate frequencies for each 
variable? This calculation can take significant amount of time for large 
datasets.}

\item{max_levels}{Numeric. Maximum levels for using in frequency 
calculations. Levels above this value will convert to 'Other values'.}
}
\value{
data.frame with following columns: Name, Class, Length, NotNA, NA, 
  Distincts, Label, ValueLabels, Min., 1st Qu., Median, Mean, 3rd Qu., Max., 
  Frequency.
}
\description{
\code{info} returns data.frame with variables description and some summary
statistics. Resulting data.frame mainly intended to keep in front of eyes in 
RStudio viewer or to be saved as csv to view in the spreadsheet software as 
reference about working dataset.
}
\examples{
data(mtcars)
var_lab(mtcars$am) = "Transmission"
val_lab(mtcars$am) = c("Automatic"=0, "Manual"=1)
info(mtcars, max_levels = 5)                             
}
