% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/permfn1.R
\name{permfn1}
\alias{permfn1}
\title{Confidence bands for the sample univariate extremogram}
\usage{
permfn1(x, p, m, type, exttype, maxlag, start = 1, alpha = 0.05)
}
\arguments{
\item{x}{Univariate time series (a vector).}

\item{p}{Quantile of the time series to indicate an extreme event (a number between 0 and 1).}

\item{m}{Number of permutations (an integer).}

\item{type}{Type of confidence bands. If type=1, it adds all permutations to the sample
extremogram plot. If type=2, it adds the \code{alpha}/2 and (1-\code{alpha})/2 empirical
confidence bands for each lag. If type=3, it calculates the lag 1 \code{alpha}/2 and
(1-\code{alpha})/2 empirical confidence bands  lag and uses them for all of the lags.}

\item{exttype}{Extremogram type (see  \code{\link{extremogram1}}).}

\item{maxlag}{Number of lags to include in the extremogram (an integer).}

\item{start}{The lag that the extremogram plots starts at (an integer not greater than \code{maxlag}, default is 1).}

\item{alpha}{Significance level for the confidence bands (a number between 0 and 1, default is 0.05).}
}
\value{
The empirical confidence bands are added to the sample univariate extremogram plot.
}
\description{
The function estimates empirical confidence bands for the sample univariate extremogram
             via a permutation procedure under the assumption that the data are independent.
}
\examples{
# generate a GARCH(1,1) process
omega   = 1
alpha   = 0.1
beta    = 0.6
n       = 1000
quant   = 0.95
exttype = 1
maxlag  = 70
df      = 3
type    = 3
m       = 10
G = extremogram:::garchsim(omega,alpha,beta,n,df)

extremogram1(G, quant, maxlag, exttype, 1, 1, 0)
permfn1(G, quant, m, type, exttype, maxlag, 1, 0.05)
}
\references{
\enumerate{
            \item Davis, R. A., Mikosch, T., & Cribben, I. (2012). Towards estimating extremal
            serial dependence via the bootstrapped extremogram. Journal of Econometrics,170(1),
            142-152.
            \item Davis, R. A., Mikosch, T., & Cribben, I. (2011). Estimating extremal
            dependence in univariate and multivariate time series via the extremogram.arXiv
            preprint arXiv:1107.5592.}
}

