% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_custom_wio.R
\name{make_custom_wio}
\alias{make_custom_wio}
\title{Make standard world input-output matrices from custom data}
\usage{
make_custom_wio(
  df,
  g_names,
  n_names = NULL,
  fd_names = NULL,
  year = NULL,
  quiet = FALSE
)
}
\arguments{
\item{df}{A data frame or matrix containing data for intermediate inputs
and final demand.}

\item{g_names}{A string vector with names of countries.}

\item{n_names}{A string vector with names of sectors. If missing, sectors
will be \code{S01}, \code{S02}, etc. If just one sector, it will be named
\code{TOTAL}.}

\item{fd_names}{A string vector with names of final demand components.
If missing, demand components will be \code{FD1}, \code{FD2}, etc. If just one,
it will be named \code{FD}.}

\item{year}{Integer. If missing, the current year will be used.}

\item{quiet}{Boolean, if \code{TRUE}, the function will produce a silent output.}
}
\value{
A \code{wio}object of \code{wiotype = "custom"}.
}
\description{
Creates a list object of class \code{wio} containing the typical
international input-output matrices in a standardized format, as well as a
list of code names (countries, sectors and demand components) and a list
of dimensions (number of countries, sectors and demand components), using
custom data.
}
\details{
\code{make_custom_wio()} creates a \code{wio} from custom input-output data  provided
as a single matrix of dimension \verb{GxN x GxFD}, i.e., the matrix \code{Z} of
intermediate inputs (dimension \verb{GxN x GxN}) bound with the matrix \code{Yfd} of
final demand (dimension \verb{GxN x GxFD}). The matrices of total output \code{X} and
value added \code{VA} will be automatically generated, so should not be
included. Data must be exclusively numeric.

A string vector with the names of countries is required. Number of countries
will be calculated from this vector. Names for sectors and final demand
components can be provided or will otherwise be automatically
generated. All names must be composed of alphabetic characters (no special
characters are allowed).
}
\examples{
df <- as.data.frame(matrix(c(19:36), nrow = 3))
wio <- make_custom_wio(df, g_names = c("C01", "C02", "C03"))
}
