% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_sum.R
\name{sumgrows}
\alias{sumgrows}
\title{Sum groups of rows of a matrix and name the resulting rows}
\usage{
sumgrows(df, n, row_names = NULL)
}
\arguments{
\item{df}{A matrix with named rows and columns.}

\item{n}{Integer, specifying the size of each group.}

\item{row_names}{String vector of length n, with names to assign to the
resulting rows.}
}
\value{
A matrix where each row is the sum of groups of n rows
of the original matrix.
}
\description{
Groups a matrix by rows, summing blocks of rows of size n each.
Matrix rows should be multiple of n.
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
sumgrows(wio$Y, wio$dims$N, wio$names$g_names)
}
