% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_sum.R
\name{sumncol}
\alias{sumncol}
\title{Sum every nth column of a matrix and name the resulting columns}
\usage{
sumncol(df, N, col_names = NULL)
}
\arguments{
\item{df}{A matrix with named rows and columns.}

\item{N}{Integer, specifying the resulting number of columns.}

\item{col_names}{String vector of length N, with names to assign to the
resulting columns.}
}
\value{
A matrix with N columns, where each columns is the sum of
every Nth column of the original matrix.
}
\description{
Groups a matrix by columns, summing every Nth column. Matrix should be
multiple of N.
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
sumncol(wio$Yfd, wio$dims$FD, paste0("WLD", "_", wio$names$fd_names))
}
