% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/va_methods.R
\name{snellen_steps}
\alias{snellen_steps}
\alias{snellensteps}
\title{Convert plus minus entries}
\usage{
snellensteps(y)
}
\arguments{
\item{y}{Vector with VA entries of class snellen - needs to be in
format xx/yy}
}
\value{
character vector of Snellen entries
}
\description{
used in conversion method for class snellen
\itemize{
\item Removing "plus" and "minus" from snellen notation
\itemize{
\item if entry -1 to +3 : take same Snellen value
\item if <= -2 : take Snellen value one line below
\item if >+3 (unlikely, but unfortunately not impossible):
Snellen value one line above
}
}
}
\section{snellen_steps}{

Snellen are unfortunately often entered with "+/-", which is a
violation of a psychophysical method designed to assign one
unambiguous value to visual acuity, with
non-arbitrary thresholds based on psychometric functions. Therefore,
transforming "+/-" notation to actual results is in itself
problematic and the below suggestion to convert it will remain an
approximation to the most likely "true" result. Even more so, as the
given conditions should work for charts with
4 or 5 optotypes in a line, and visual acuity is not always tested
on such charts. Yet, I believe that the approach is still better than
just omitting the letters or (worse) assigning a missing value to those
entries.
}

\seealso{
https://en.wikipedia.org/wiki/Psychometric_function

Other VA converter: 
\code{\link{va_dissect}()},
\code{\link{va_methods}},
\code{\link{va}()},
\code{\link{which_va}()}
}
\concept{VA converter}
