% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-deblink.R
\name{deblink}
\alias{deblink}
\title{NA-pad blink events / missing data}
\usage{
deblink(eyeris, extend = 40)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} dervived from \code{\link[=load]{load()}}.}

\item{extend}{Either a single number indicating the number of milliseconds to
pad forward/backward around each missing sample, or, a vector of length two
indicating different numbers of milliseconds pad forward/backward around each
missing sample, in the format \code{c(backward, forward)}.}
}
\value{
An \code{eyeris} object with a new column: \verb{pupil_raw_\{...\}_deblink}.
}
\description{
Deblinking (a.k.a. NA-padding) of time series data. The intended use of
this method is to remove blink-related artifacts surrounding periods of
missing data. For instance, when an individual blinks, there are usually
rapid decreases followed by increases in pupil size, with a chunk of data
missing in-between these 'spike'-looking events. The deblinking procedure
here will NA-pad each missing data point by your specified number of ms.
}
\examples{
system.file("extdata", "memory.asc", package = "eyeris") |>
  eyeris::load_asc() |>
  eyeris::deblink(extend = 40) |> # 40 ms in both directions
  plot(seed = 0)

system.file("extdata", "memory.asc", package = "eyeris") |>
  eyeris::load_asc() |>
  eyeris::deblink(extend = c(40, 50)) |> # 40 ms backward, 50 ms forward
  plot(seed = 0)

}
