% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.eyeris.R
\name{plot_detrend_overlay}
\alias{plot_detrend_overlay}
\title{Internal helper to plot detrending overlay}
\usage{
plot_detrend_overlay(
  pupil_data,
  pupil_steps,
  preview_n = preview_n,
  plot_params = list(),
  suppress_prompt = TRUE
)
}
\arguments{
\item{pupil_data}{A single block of pupil timeseries data
(e.g. \code{eyeris$timeseries$block_1})}

\item{preview_n}{Number of columns for \code{par(mfrow)}. Default = 3.}

\item{plot_params}{A named list of additional parameters to forward to
\code{robust_plot()}}

\item{suppress_prompt}{Logical. Whether to skip prompting. Default = TRUE.}
}
\description{
This function replicates the exact detrending visualization from the
\code{glassbox()} interactive preview mode. It uses \code{robust_plot()} to show the
most recent detrended pupil signal overlaid with the fitted linear trend.
}
\keyword{internal}
