\name{createParDef}
\alias{createParDef}
\alias{parameterDef}
\title{Create a parameterDef Object.}
\usage{
  createParDef(selection = list(), banker = list())
}
\arguments{
  \item{selection}{A list of scalar parameters}

  \item{banker}{A list of other parameters}
}
\value{
  A parameterDef object
}
\description{
  createParDef creates a new parameterDef object from a
  list of scalar parameters and a list of other parameters.
  parameterDef is a short hand of "parameter definition".
  It defines parameters used by the \code{\link{dgp}} which
  is the most important part of a simulation. For each
  simulation,There is a particular set of parameter.
  parameterDef allow us to define several parameters for
  different simulation at once. There are two types of
  parameter in parameterDef, scalar parameters and other
  parameters. Scalar parameters must be a scalar. Any
  vectors or matrix is regarded as a sequence of scalar
  parameters. For example, n=seq(10,50,10), first
  simulation takes n=10, second simulation takes n=20 and
  so on. Other parameters can be anything and it is banker
  over the scalar parameters. For example, we would like to
  know how would the sample size affect the variance of the
  sample mean of normally distributed variable. We can set
  n=seq(10,50,10), mean=1 and sd=2.  (see example)
}
\examples{
par_def1<-createParDef(selection=list(mean=1,sd=2,n=seq(10,50,10)))

par_def2<-createParDef()
setSelection(par_def2,mean=1,sd=2,n=seq(10,50,10))

identical(par_def1,par_def2)

evalFunctionOnParameterDef(par_def1, function() rnorm(n,mean,sd) )  # 10 random number
evalFunctionOnParameterDef(par_def1, function() rnorm(n,mean,sd), index=3)  # 30 random number

generate(par_def1)

# More than 1 selection parameters
par_def3<-createParDef(selection=list(sd=2,mean=1:3,n=seq(10,50,10)))

generate(par_def3)
}
\author{
  TszKin Julian Chan \email{ctszkin@gmail.com}
}
\seealso{
  \code{\link{setBanker.parameterDef}},\code{\link{setSelection.parameterDef}},\code{\link{evalFunctionOnParameterDef}},\code{\link{generate.parameterDef}}
}

