% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_dim.R
\name{pick_dim}
\alias{pick_dim}
\title{Number Of Principal Component Selection Based On Variation}
\usage{
pick_dim(fdobj, TVE)
}
\arguments{
\item{fdobj}{Functional data object, class of \code{"fd"}}

\item{TVE}{Total Variation Explained. It must be in [0,1].}
}
\value{
\item{\code{d}}{
Minimum number of Principle components needed in order to reach desired \code{TVE}
}
\item{\code{TVEs}}{
Vector of TVEs. This has the same length of number of basis that the functional data is represented
}
}
\description{
This function selects number of principal components based on the total variation explained (TVE). The functional data is
projected onto a smaller number of principal curves via functional Principal Component Analysis (fPCA). This function
picks the dimension of the projection space based on the desired total variation explained.
}
\details{
This function is used to determine the dimension of the space that the functional data is projected onto
based on the variation. One of the common treatments of the functional data is to transform it to multivariate
objects using so called score vectors and utilize the multivariate techniques. This function will enable users
to pick the dimension of the score vectors.
}
\examples{
fdata1 = fun_IID(n=100, nbasis=21)
pick_dim(fdata1, 0.95)
fdata2 = fun_IID(n=100, nbasis=21, Sigma=3^-(1:21))
pick_dim(fdata2, 0.95)


}
\references{
Ramsay, James O., and Silverman, Bernard W. (2006), \emph{Functional
Data Analysis, 2nd ed.}, Springer, New York
}
\seealso{
\code{\link{pca.fd}}
}
