% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfts.R
\name{minmax}
\alias{minmax}
\alias{max.dfts}
\alias{min.dfts}
\title{Max / Min for dfts Objects}
\usage{
\method{max}{dfts}(x, type = c("Obs", "fparam"), na.rm = TRUE, ...)

\method{min}{dfts}(x, type = c("Obs", "fparam"), na.rm = TRUE, ...)
}
\arguments{
\item{x}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{type}{String indicating if finding for observation ('Obs'),
or for pointwise values ('fparam').}

\item{na.rm}{Boolean if NA values should be removed. Defaults to TRUE.}

\item{...}{Additional parameters to pass to base R's \code{min} or \code{max}
functions. They are only used in the \code{type='fparam'} case.}
}
\value{
A dfts object.
}
\description{
Get the observation(s) or pointwise values with the min / max values. When
using \code{type='Obs'}, the selected observation is the one with the
minimum or maximum mean. When using \code{type='fparam'}, the values are
given pointwise.
}
\examples{
results <- max(electricity)
results <- min(electricity)
}
