test_that("(Scaled) ALD function has proper 1st, 2nd and 3rd noncentralized moments", {
  # 1st moment
  expect_equal(
    vapply(
      X = 1:8,
      FUN = function(.x) {
        integrate(function(x, .x, dfun) {x * dfun(x, P = .x)}, lower = -Inf, upper = Inf, .x = .x, dfun = pdf_ald_v1)[[1]]
      },
      FUN.VALUE = numeric(1)
    ),
    rep(0, 8)
  )
  # 2nd moment
  expect_equal(
    vapply(
      X = 1:8,
      FUN = function(.x) {
        integrate(function(x, .x, dfun) {x^2 * dfun(x, P = .x)}, lower = -Inf, upper = Inf, .x = .x, dfun = pdf_ald_v1)[[1]]
      },
      FUN.VALUE = numeric(1)
    ),
    rep(1, 8)
  )
  # 3rd moment
  expect_equal(
    vapply(
      X = 1:8,
      FUN = function(.x) {
        integrate(function(x, .x, dfun) {x^3 * dfun(x, P = .x)}, lower = -Inf, upper = Inf, .x = .x, dfun = pdf_ald_v1)[[1]]
      },
      FUN.VALUE = numeric(1)
    ),
    rep(0, 8)
  )
})
test_that("(Scaled) ALD function returns values as expected", {
  # Check values for different dfs
  expect_equal(
    lapply(
      X = 1:8,
      FUN = function(.x) {
        c(pdf_ald_v1(c(-1.96, -1, -0.5, -0.25, 0, 0.25, 0.5, 1, 1.96), .x))
      }
    ),
list(c(0.0488090930711509, 0.203002924854919, 0.367879441171442,
0.454897994784475, 0.5, 0.454897994784475, 0.367879441171442,
0.203002924854919, 0.0488090930711509), c(0.0509160045872038,
0.216089098644371, 0.367707765494313, 0.432533604571886, 0.459279326771846,
0.432533604571886, 0.367707765494313, 0.216089098644371, 0.0509160045872038
), c(0.0522030317618069, 0.222995459021513, 0.365605864871559,
0.42070925972031, 0.441941738241592, 0.42070925972031, 0.365605864871559,
0.222995459021513, 0.0522030317618069), c(0.053092808761855,
0.227149828889243, 0.363678665376467, 0.413625050893106, 0.432342648851146,
0.413625050893106, 0.363678665376467, 0.227149828889243, 0.053092808761855
), c(0.0537521566933679, 0.229880216156848, 0.36213554302708,
0.408950771925419, 0.426246878425153, 0.408950771925419, 0.36213554302708,
0.229880216156848, 0.0537521566933679), c(0.0542632137192048,
0.231793539677665, 0.360917707523463, 0.405646914882731, 0.4220326446996,
0.405646914882731, 0.360917707523463, 0.231793539677665, 0.0542632137192048
), c(0.0546721741351684, 0.233200680995967, 0.359946288516782,
0.403191579246685, 0.4189453125, 0.403191579246685, 0.359946288516782,
0.233200680995967, 0.0546721741351684), c(0.0550074127454705,
0.23427510367536, 0.359158837131503, 0.401296515121209, 0.416586194177438,
0.401296515121209, 0.359158837131503, 0.23427510367536, 0.0550074127454705
))
  )

  # Check symmetry once again numerically for different P values
  expect_equal(
  lapply(
    X = 1:8,
    FUN = function(.x) {
      pdf_ald_v1(c(-1.96, -1, -0.5, -0.25, -0.1), P = .x)
    }
  ),
  lapply(
    X = 1:8,
    FUN = function(.x) {
      pdf_ald_v1(c(1.96, 1, 0.5, 0.25, 0.1), P = .x)
    }
  )
  )

})

#------------------------------------------------------

test_that("Check likelihood function for (scaled) ALD", {
  expect_equal(
  lapply(
    X = 1:8,
    FUN = function(.x) {
      c(pdf_ald(c(-1.96, -1.5, -1, -0.5, -0.25, 0, 0.25, 0.5, 1, 1.5, 1.96),
              mu = rep(0.05, 11), sigt = rep(0.5, 11), P = .x))
    }
  ),
list(c(0.00291367290907593, 0.0146119005813293, 0.0779769994664841,
0.354570106759468, 0.662627266206845, 0.982476903693578, 0.808792135410999,
0.462836887020442, 0.107379704909595, 0.0205873722685555, 0.00415435782578441
), c(0.00209792897281901, 0.0128700915028995, 0.0801997049867767,
0.379562783496462, 0.673869757400596, 0.909494154821453, 0.793005567234987,
0.488813264731665, 0.112616404448839, 0.0188233374300661, 0.00313652208097899
), c(0.00165227701342307, 0.0117546143145517, 0.0814998220167119,
0.393368839478686, 0.676110980169778, 0.876858995913558, 0.781238986837047,
0.501691727099922, 0.115840359658003, 0.0176554640550189, 0.00255919969952472
), c(0.00137419690732309, 0.0109783421384928, 0.0823857619266356,
0.401970220425706, 0.676126697504292, 0.858539686089741, 0.77315348396443,
0.509073619131075, 0.118071959268276, 0.0168273687727675, 0.00218901388120603
), c(0.00118526117322244, 0.0104059977989573, 0.0830409202150539,
0.407778035345319, 0.675559833001406, 0.846834725156581, 0.767425553525857,
0.513747170930332, 0.119723525445447, 0.0162093857638309, 0.00193210989639446
), c(0.00104905819777693, 0.00996596541662537, 0.0835504077705497,
0.41193439013516, 0.674875380734408, 0.838714783929022, 0.763201266971599,
0.516927235404157, 0.12100082324207, 0.0157302489331927, 0.00174369669889976
), c(0.000946491076179775, 0.00961678029108333, 0.0839603678420435,
0.415042534867364, 0.674213426570712, 0.832753069602669, 0.759972972962261,
0.519211531793196, 0.122020411750682, 0.0153476886828575, 0.00159976381452446
), c(0.000866623627334932, 0.00933274296553738, 0.0842985459626062,
0.417447877729426, 0.673613281864836, 0.828190611298353, 0.757431875682255,
0.520922511238112, 0.122854131558914, 0.0150350549581486, 0.00148630987050846
))
)
})
