% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fHMM_colors.R
\name{fHMM_colors}
\alias{fHMM_colors}
\title{Setting color scheme for visualizations}
\usage{
fHMM_colors(controls, colors = NULL)
}
\arguments{
\item{controls}{An object of class \code{fHMM_controls}.}

\item{colors}{Either \code{NULL} or a character vector of color names or hexadecimal RGB
triplets.}
}
\value{
An object of class \code{fHMM_colors}, which is:
\itemize{
\item for \code{controls$hierarchy == FALSE} a vector of length
\code{controls$states} of color codes,
\item for \code{controls$hierarchy == TRUE} a list of
\itemize{
\item a vector of length  \code{controls$states[1]} and
\item a matrix of dimensions \code{controls$states} of color codes.
}
}
}
\description{
This function defines a color scheme for visualizations in the {fHMM} package.
}
\examples{
controls <- set_controls()
fHMM:::fHMM_colors(controls, colors = c("red", "blue"))
}
