% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{simulate_markov_chain}
\alias{simulate_markov_chain}
\title{Simulate a Markov chain}
\usage{
simulate_markov_chain(
  Gamma,
  T,
  delta = Gamma2delta(Gamma),
  seed = NULL,
  total_length = T
)
}
\arguments{
\item{Gamma}{A tpm (transition probability matrix).}

\item{T}{The length of the Markov chain.}

\item{delta}{A probability vector, the initial distribution. If not specified, \code{delta}
is set to the stationary distribution vector.}

\item{seed}{Set a seed.}

\item{total_length}{An integer, the total length of the output vector. Must be greater or equal
than \code{T}.}
}
\value{
A numeric vector of length \code{T} with states.
}
\description{
This function simulates a Markov chain.
}
\examples{
Gamma <- matrix(c(0.5, 0.3, 0.5, 0.7), 2, 2)
T <- 10
fHMM:::simulate_markov_chain(Gamma = Gamma, T = T)
}
\keyword{utils}
