% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_and_models.R
\docType{data}
\name{unemp_spx_model_3_2}
\alias{unemp_spx_model_3_2}
\title{Unemployment rate and S&P 500 hierarchical HMM}
\format{
An object of class \code{\link{fHMM_model}}.
}
\usage{
data("unemp_spx_model_3_2")
}
\description{
A pre-computed HHMM with monthly unemployment rate in the US on the coarse
scale using 3 states and S&P 500 index data on the fine scale using 2 states
from 1970 to 2020 for demonstration purpose.
}
\details{
The model was estimated via:
\preformatted{
controls <- set_controls(
 hierarchy = TRUE,
 states    = c(3, 2),
 sdds      = c("t", "t"),
 period    = "m",
 data      = list(
   file        = list(unemp, spx),
   date_column = c("date", "Date"),
   data_column = c("rate_diff", "Close"),
   from        = "1970-01-01",
   to          = "2020-01-01",
   logreturns  = c(FALSE, TRUE)
 ),
 fit       = list(
   runs        = 50, 
   iterlim     = 1000,
   gradtol     = 1e-6,
   steptol     = 1e-6
 )
)
unemp_spx_data <- prepare_data(controls)
unemp_spx_model_3_2 <- fit_model(unemp_spx_data, seed = 1, ncluster = 25)
unemp_spx_model_3_2 <- decode_states(unemp_spx_model_3_2)
unemp_spx_model_3_2 <- compute_residuals(unemp_spx_model_3_2)
summary(unemp_spx_model_3_2)
state_order <- matrix(c(3, 2, 1, 2, 2, 2, 1, 1, 1), 3, 3)
unemp_spx_model_3_2 <- reorder_states(unemp_spx_model_3_2, state_order)
}
}
\keyword{model}
