% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{abundance.matrix}
\alias{abundance.matrix}
\title{abundance matrix}
\usage{
abundance.matrix(data, times = seq(0, data$maxtime, length.out = 50),
  by.age = FALSE, cap.living = FALSE)
}
\arguments{
\item{data}{result of a simulation, created by \code{\link{community}}}

\item{times}{array of times at which the abundances will be calculated}

\item{by.age}{T/F. Use this option to get the number of individuals to reach each age, instead of
abundances for each time.}

\item{cap.living}{Logical. Use this option with by.age=T, to set the time of death of living individuals to max
simulation time. Otherwise, living individuals are excluded from the data. Either way, this data
will be more representative if only a small fraction of total individuals is living at the end of
simulation.}
}
\description{
Returns a matrix with abundances of each life stage/species over time
}
\details{
The rows in the matrix are the lifestages/species id. The times are in the row names. To
visualize the abundance matrix data we recomment the function \code{\link{stackplot}}.
}
\examples{
data(malthusian)
times <- seq(0,malthusian$maxtime,by=0.1)
ab <- abundance.matrix(malthusian,times)

ab.by.age <- abundance.matrix(malthusian,times,by.age=TRUE)

}
