% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{quantFit}
\alias{quantFit}
\title{Quality of quantile fit statistics.}
\usage{
quantFit(x, ...)
}
\arguments{
\item{x}{Object of class \code{fairadapt}, a result of an adaptation
procedure.}

\item{...}{Ignored in this case.}
}
\value{
A \code{numeric} vector, containing the average empirical loss for
the 25\%, 50\% and 75\% quantile loss functions, for each variable.
}
\description{
Quality of quantile fit statistics.
}
\examples{
n_samp <- 200
uni_dim <- c(       "gender", "edu", "test", "score")
uni_adj <- matrix(c(       0,     1,      1,       0,
                           0,     0,      1,       1,
                           0,     0,      0,       1,
                           0,     0,      0,       0),
                  ncol = length(uni_dim),
                  dimnames = rep(list(uni_dim), 2),
                  byrow = TRUE)

uni_ada <- fairadapt(score ~ .,
  train.data = head(uni_admission, n = n_samp),
  test.data = tail(uni_admission, n = n_samp),
  adj.mat = uni_adj,
  prot.attr = "gender",
  eval.qfit = 3L
)

quantFit(uni_ada)
}
