% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mimic}
\alias{mimic}
\title{Clinical data from the MIMIC-II database for a case study on
indwelling arterial catheters}
\format{
A data frame with 1776 rows and 46 variables:
\describe{
\item{\code{aline_flg}}{Integer, indicates if IAC was used (1 = yes, 0 = no)}
\item{\code{icu_los_day}}{Double, length of stay in ICU (days)}
\item{\code{hospital_los_day}}{Integer, length of stay in hospital (days)}
\item{\code{age}}{Double, age at baseline (years)}
\item{\code{gender_num}}{Integer, patient gender (1 = male; 0 = female)}
\item{\code{weight_first}}{Double, first weight (kg)}
\item{\code{bmi}}{Double, patient BMI}
\item{\code{sapsi_first}}{Integer, first SAPS I score}
\item{\code{sofa_first}}{Integer, first SOFA score}
\item{\code{service_unit}}{Character, type of service unit (FICU, MICU, SICU)}
\item{\code{service_num}}{Integer, service as a numeric value (0 = MICU or FICU, 1 = SICU)}
\item{\code{day_icu_intime}}{Character, day of week of ICU admission}
\item{\code{day_icu_intime_num}}{Integer, day of week of ICU admission (numeric)}
\item{\code{hour_icu_intime}}{Integer, hour of ICU admission (24hr clock)}
\item{\code{hosp_exp_flg}}{Integer, death in hospital (1 = yes, 0 = no)}
\item{\code{icu_exp_flg}}{Integer, death in ICU (1 = yes, 0 = no)}
\item{\code{day_28_flg}}{Integer, death within 28 days (1 = yes, 0 = no)}
\item{\code{mort_day_censored}}{Double, day post ICU admission of censoring or death (days)}
\item{\code{censor_flg}}{Integer, censored or death (0 = death, 1 = censored)}
\item{\code{sepsis_flg}}{Integer, sepsis present (0 = no, 1 = yes)}
\item{\code{chf_flg}}{Integer, congestive heart failure (0 = no, 1 = yes)}
\item{\code{afib_flg}}{Integer, atrial fibrillation (0 = no, 1 = yes)}
\item{\code{renal_flg}}{Integer, chronic renal disease (0 = no, 1 = yes)}
\item{\code{liver_flg}}{Integer, liver disease (0 = no, 1 = yes)}
\item{\code{copd_flg}}{Integer, chronic obstructive pulmonary disease (0 = no, 1 = yes)}
\item{\code{cad_flg}}{Integer, coronary artery disease (0 = no, 1 = yes)}
\item{\code{stroke_flg}}{Integer, stroke (0 = no, 1 = yes)}
\item{\code{mal_flg}}{Integer, malignancy (0 = no, 1 = yes)}
\item{\code{resp_flg}}{Integer, respiratory disease (non-COPD) (0 = no, 1 = yes)}
\item{\code{map_1st}}{Double, mean arterial pressure (mmHg)}
\item{\code{hr_1st}}{Integer, heart rate}
\item{\code{temp_1st}}{Double, temperature (F)}
\item{\code{spo2_1st}}{Integer, S_pO_2 (percent)}
\item{\code{abg_count}}{Integer, arterial blood gas count (number of tests)}
\item{\code{wbc_first}}{Double, first white blood cell count (K/uL)}
\item{\code{hgb_first}}{Double, first hemoglobin (g/dL)}
\item{\code{platelet_first}}{Integer, first platelets (K/u)}
\item{\code{sodium_first}}{Integer, first sodium (mEq/L)}
\item{\code{potassium_first}}{Double, first potassium (mEq/L)}
\item{\code{tco2_first}}{Double, first bicarbonate (mEq/L)}
\item{\code{chloride_first}}{Integer, first chloride (mEq/L)}
\item{\code{bun_first}}{Integer, first blood urea nitrogen (mg/dL)}
\item{\code{creatinine_first}}{Double, first creatinine (mg/dL)}
\item{\code{po2_first}}{Integer, first PaO_2 (mmHg)}
\item{\code{pco2_first}}{Integer, first PaCO_2 (mmHg)}
\item{\code{iv_day_1}}{Double, input fluids by IV on day 1 (mL)}
}
}
\source{
\url{https://physionet.org/content/mimic2-iaccd/1.0/}
}
\usage{
mimic
}
\description{
The Indwelling Arterial Catheter Clinical dataset contains
clinical data for 1776 patients from the MIMIC-II clinical database. It was
the basis for the article: Hsu DJ, et al. The association between indwelling
arterial catheters and mortality in hemodynamically stable patients with
respiratory failure: A propensity score analysis. Chest, 148(6):1470–1476,
Aug. 2015. This dataset was also used by Raffa et al. in Chapter 5 "Data
Analysis" of the forthcoming book: Secondary Analysis of Electronic Health
Records, published by Springer in 2016.
}
\keyword{datasets}
