% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_parity.R
\name{prop_parity}
\alias{prop_parity}
\title{Proportional parity}
\usage{
prop_parity(data, group, probs = NULL, preds = NULL, cutoff = 0.5,
  base = NULL)
}
\arguments{
\item{data}{The dataframe that contains the necessary columns.}

\item{group}{Sensitive group to examine.}

\item{probs}{The column name or vector of the predicted probabilities (numeric between 0 - 1). If not defined, argument preds needs to be defined.}

\item{preds}{The column name or vector of the predicted outcome (categorical outcome). If not defined, argument probs needs to be defined.}

\item{cutoff}{Cutoff to generate predicted outcomes from predicted probabilities. Default set to 0.5.}

\item{base}{Base level for sensitive group comparison}
}
\value{
\item{Metric}{Raw proportions for all groups and metrics standardized for the base group (proportional parity metric). Lower values compared to the reference group mean lower proportion of positively predicted observations in the selected subgroups}
\item{Metric_plot}{Bar plot of Proportional parity metric}
\item{Probability_plot}{Density plot of predicted probabilities per subgroup. Only plotted if probabilities are defined}
}
\description{
This function computes the Proportional parity metric
}
\details{
This function computes the Proportional parity metric (also known as Impact Parity or Minimizing Disparate Impact) as described by Calders and Verwer 2010.
Proportional parity is calculated based on the comparison of the proportion of all positively classified individuals in all subgroups of the data.
In the returned named vector, the reference group will be assigned 1, while all other groups will be assigned values
according to whether their proportion of positively predicted observations are lower or higher compared to the reference group. Lower
proportions will be reflected in numbers lower than 1 in the returned named vector.
}
\examples{
data(compas)
prop_parity(data = compas, group = 'ethnicity',
probs = 'probability', preds = NULL,
cutoff = 0.4, base = 'Caucasian')
prop_parity(data = compas, group = 'ethnicity',
probs = NULL, preds = 'predicted',
cutoff = 0.5, base = 'Hispanic')

}
