% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{write_makefile}
\alias{write_makefile}
\title{Write a \code{Makelist} to File}
\usage{
write_makefile(make_list, path, Rbin = "Rscript-devel")
}
\arguments{
\item{make_list}{The list to write to file.}

\item{path}{The path to the file.}

\item{Rbin}{The R binary to use in the \command{Makefile}.}
}
\value{
See
\code{\link[MakefileR:write_makefile]{MakefileR::write_makefile}}.
}
\description{
The \code{makelist} is parsed before writing, so all \R code which is not in
a "code" item will be evaluated.
So if any other item's string contains code allowing for a dynamic rule,
for example with some "dependencies" reading
\code{"list.files(\"R\", full.names = TRUE)"}, the \command{Makefile} will
have the
evaluated code, a list static list of files in the above case.
}
\examples{
make_file <- file.path(tempdir(), "my_Makefile")
write_makefile(provide_make_list(), path = make_file)
cat(readLines(make_file), sep = "\\n")
}
