% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makelists.R
\name{get_target}
\alias{get_target}
\title{Get a Makelist's Target}
\usage{
get_target(makelist, alias)
}
\arguments{
\item{makelist}{A list for
\code{\link[fakemake:make]{make}}.}

\item{alias}{The alias of the target in question.}
}
\value{
A list (the target requested).
}
\description{
Get a single target from a \code{makelist} by
alias.
}
\examples{
ml <- provide_make_list()
visualize(ml, root = "all.Rout")
i <- which(sapply(ml, "[[", "target") == "b1.Rout")
ml[[i]]["alias"] <- "b1"
t <- get_target(ml, "b1")
ml <- remove_target(ml, t[["target"]])
visualize(ml)
ml <- add_target(ml, target = t[["target"]], code = t[["code"]],
                sink = t[["sink"]],
                prerequisite_to = "a1.Rout", alias = NULL)
all.equal(ml, provide_make_list())
}
\seealso{
Other functions to manipulate makelists: 
\code{\link{add_target}()},
\code{\link{remove_target}()}
}
\concept{functions to manipulate makelists}
