% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarCollection.R
\name{set_class_names,familiarCollection-method}
\alias{set_class_names,familiarCollection-method}
\alias{set_class_names}
\title{Rename outcome classes for plotting and export}
\usage{
\S4method{set_class_names}{familiarCollection}(x, old = NULL, new = NULL, order = NULL)
}
\arguments{
\item{x}{A familiarCollection object.}

\item{old}{(optional) Set of old labels to replace.}

\item{new}{Set of replacement labels. The number of replacement labels should
be equal to the number of provided old labels or the full number of labels.
If a subset of labels is to be replaced, both \code{old} and \code{new}
should be provided.}

\item{order}{(optional) Ordered set of replacement labels. This is used to
provide the order in which the labels should be placed, which affects e.g.
levels in a plot. If the ordering is not explicitly provided, the old
ordering is used.}
}
\value{
A familiarCollection object with updated labels.
}
\description{
Tabular exports and figures created from a familiarCollection
object can be customised by providing names for outcome classes.
}
\details{
Labels convert the internal naming for class levels to the requested
label at export or when plotting. This enables customisation of class
names. Currently assigned labels can be found using the
\code{get_class_names} method.
}
\seealso{
\itemize{
\item \linkS4class{familiarCollection} for information concerning the
familiarCollection class. * \code{\link{get_class_names}} for obtaining
currently assigned class names.
}
}
