% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tohtml.R
\name{in_html}
\alias{in_html}
\title{Frame HTML in a Web Page And Display}
\usage{
in_html(x, css = character(), pre = TRUE, display = TRUE, clean = display)
}
\arguments{
\item{x}{character vector of html encoded strings.}

\item{css}{character vector of css styles.}

\item{pre}{TRUE (default) or FALSE, whether to wrap \code{x} in PRE tags.}

\item{display}{TRUE or FALSE, whether to display the resulting page in a
browser window.  If TRUE, will sleep for one second before returning, and
will delete the temporary file used to store the HTML.}

\item{clean}{TRUE or FALSE, if TRUE and \code{display == TRUE}, will delete the
temporary file used for the web page, otherwise will leave it.}
}
\value{
character(1L) the file location of the page, invisibly, but keep in
mind it will have been deleted if \code{clean=TRUE}.
}
\description{
Helper function that assembles user provided HTML and CSS into a temporary
text file, and by default displays it in the browser.  Intended for use in
examples.
}
\examples{
txt <- "\033[31;42mHello \033[7mWorld\033[m"
writeLines(txt)
html <- sgr_to_html(txt)
\dontrun{
in_html(html) # spawns a browser window
}
writeLines(readLines(in_html(html, display=FALSE)))
css <- "SPAN {text-decoration: underline;}"
writeLines(readLines(in_html(html, css=css, display=FALSE)))
\dontrun{
in_html(html, css)
}
}
\seealso{
\code{\link[=make_styles]{make_styles()}}.

Other HTML functions: 
\code{\link{html_esc}()},
\code{\link{make_styles}()},
\code{\link{sgr_to_html}()}
}
\concept{HTML functions}
