% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strsplit.R
\name{strsplit_ctl}
\alias{strsplit_ctl}
\alias{strsplit_sgr}
\title{ANSI Control Sequence Aware Version of strsplit}
\usage{
strsplit_ctl(
  x,
  split,
  fixed = FALSE,
  perl = FALSE,
  useBytes = FALSE,
  warn = getOption("fansi.warn"),
  term.cap = getOption("fansi.term.cap"),
  ctl = "all"
)

strsplit_sgr(
  x,
  split,
  fixed = FALSE,
  perl = FALSE,
  useBytes = FALSE,
  warn = getOption("fansi.warn"),
  term.cap = getOption("fansi.term.cap")
)
}
\arguments{
\item{x}{a character vector, or, unlike \link[base:strsplit]{base::strsplit} an object that can
be coerced to character.}

\item{split}{
    character vector (or object which can be coerced to such)
    containing \link[base]{regular expression}(s) (unless \code{fixed = TRUE})
    to use for splitting.  If empty matches occur, in particular if
    \code{split} has length 0, \code{x} is split into single characters.
    If \code{split} has length greater than 1, it is re-cycled along
    \code{x}.
  }

\item{fixed}{
    logical.  If \code{TRUE} match \code{split} exactly, otherwise
    use regular expressions.  Has priority over \code{perl}.
  }

\item{perl}{logical.  Should Perl-compatible regexps be used?}

\item{useBytes}{logical.  If \code{TRUE} the matching is done
    byte-by-byte rather than character-by-character, and inputs with
    marked encodings are not converted.  This is forced (with a warning)
    if any input is found which is marked as \code{"bytes"}
    (see \code{\link[base]{Encoding}}).}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}

\item{term.cap}{character a vector of the capabilities of the terminal, can
be any combination of "bright" (SGR codes 90-97, 100-107), "256" (SGR codes
starting with "38;5" or "48;5"), and "truecolor" (SGR codes starting with
"38;2" or "48;2"). Changing this parameter changes how \code{fansi}
interprets escape sequences, so you should ensure that it matches your
terminal capabilities. See \link{term_cap_test} for details.}

\item{ctl}{character, which \emph{Control Sequences} should be treated
specially. See the "_ctl vs. _sgr" section for details.
\itemize{
\item "nl": newlines.
\item "c0": all other "C0" control characters (i.e. 0x01-0x1f, 0x7F), except
for newlines and the actual ESC (0x1B) character.
\item "sgr": ANSI CSI SGR sequences.
\item "csi": all non-SGR ANSI CSI sequences.
\item "esc": all other escape sequences.
\item "all": all of the above, except when used in combination with any of the
above, in which case it means "all but".
}}
}
\value{
list, see \link[base:strsplit]{base::strsplit}.
}
\description{
A drop-in replacement for \link[base:strsplit]{base::strsplit}.  It will be noticeably slower,
but should otherwise behave the same way except for \emph{Control Sequence}
awareness.
}
\details{
This function works by computing the position of the split points after
removing \emph{Control Sequences}, and uses those positions in conjunction with
\code{\link{substr_ctl}} to extract the pieces.  This concept is borrowed from
\code{crayon::col_strsplit}.  An important implication of this is that you cannot
split by \emph{Control Sequences} that are being treated as \emph{Control Sequences}.
You can however limit which control sequences are treated specially via the
\code{ctl} parameters (see examples).
}
\note{
Non-ASCII strings are converted to and returned in UTF-8 encoding.  The
split positions are computed after both \code{x} and \code{split} are converted to
UTF-8.
}
\section{_ctl vs. _sgr}{


The \verb{*_ctl} versions of the functions treat all \emph{Control Sequences} specially
by default.  Special treatment is context dependent, and may include
detecting them and/or computing their display/character width as zero.  For
the SGR subset of the ANSI CSI sequences, \code{fansi} will also parse, interpret,
and reapply the text styles they encode if needed.  You can modify whether a
\emph{Control Sequence} is treated specially with the \code{ctl} parameter.  You can
exclude a type of \emph{Control Sequence} from special treatment by combining
"all" with that type of sequence (e.g. \code{ctl=c("all", "nl")} for special
treatment of all \emph{Control Sequences} \strong{but} newlines).  The \verb{*_sgr} versions
only treat ANSI CSI SGR sequences specially, and are equivalent to the
\verb{*_ctl} versions with the \code{ctl} parameter set to "sgr".
}

\examples{
strsplit_sgr("\033[31mhello\033[42m world!", " ")

## Next two examples allow splitting by newlines, which
## normally doesn't work as newlines are _Control Sequences_
strsplit_sgr("\033[31mhello\033[42m\nworld!", "\n")
strsplit_ctl("\033[31mhello\033[42m\nworld!", "\n", ctl=c("all", "nl"))
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results,
\link[base:strsplit]{base::strsplit} for details on the splitting.
}
