% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustMD.R
\name{robustMD}
\alias{plot.robmah}
\alias{print.robmah}
\alias{robustMD}
\title{Robust Mahalanobis}
\usage{
robustMD(data, method = "mve", ...)

\method{print}{robmah}(x, ncases = 10, digits = 5, ...)

\method{plot}{robmah}(x, y = NULL, type = "xyplot", main, ...)
}
\arguments{
\item{data}{matrix or data.frame}

\item{method}{type of estimation for robust means and covariance
(see \code{\link{cov.rob}})}

\item{...}{additional arguments to pass to \code{MASS::cov.rob()}}

\item{x}{an object of class \code{robmah}}

\item{ncases}{number of extreme cases to print}

\item{digits}{number of digits to round in the final result}

\item{y}{empty parameter passed to \code{plot}}

\item{type}{type of plot to display, can be either \code{'qqplot'} or \code{'xyplot'}}

\item{main}{title for plot. If missing titles will be generated automatically}
}
\description{
Obtain Mahalanobis distances using the robust
computing methods found in the \code{MASS} package. This function is generally only applicable
to models with continuous variables.
}
\examples{

\dontrun{
data(holzinger)
output <- robustMD(holzinger)
output
plot(output)
plot(output, type = 'qqplot')
}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\references{
Flora, D. B., LaBrish, C. & Chalmers, R. P. (2012). Old and new ideas for data screening and assumption testing for
exploratory and confirmatory factor analysis. \emph{Frontiers in Psychology, 3}, 1-21.
}
\seealso{
\code{\link{gCD}}, \code{\link{obs.resid}}, \code{\link{LD}}
}
\keyword{covariance}

