/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.ArrayList;
import java.util.Set;
import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.BadModelException;
import jfm.model.ELS;
import jfm.model.ELSOption;
import jfm.model.Farm;
import jfm.model.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELSOptionsComponent
extends ModelComponent {
    private final ArrayList<Types.ELSCode> availableOptions;
    private final ELS elsObject;

    public ELSOptionsComponent(double paymentRate_, double pointsRate_, ArrayList<Types.ELSCode> availableOptions_) {
        super(ModelComponent.MCType.ELSOPTIONS);
        this.elsObject = new ELS(paymentRate_, pointsRate_);
        this.requireObjective(Types.ObjectiveType.ELSCOMPLEXITY);
        this.requireObjective(Types.ObjectiveType.PROFIT);
        this.availableOptions = availableOptions_;
        this.addConstraintBuilder(new AcceptanceToELSConstraint());
    }

    @Override
    public ModelComponent copy() {
        return null;
    }

    @Override
    protected void initializeStructure() throws BadModelException {
        this.elsObject.registerParent(this);
        MatrixVariable newVariable = new MatrixVariable(this.elsObject.getAnnualSubsidy(), 0.0, 1.0, LPX.LPX_DB, LPX.LPX_IV, this.matrix.numCols(), Types.ObjectiveType.PROFIT);
        newVariable.setTag(this.elsObject.name());
        this.matrix.addVariable(newVariable);
        this.elsObject.registerVariable(newVariable, 0);
    }

    @Override
    protected String name() {
        return null;
    }

    @Override
    public void setFormulaVariables() {
    }

    @Override
    protected void updateStructure() {
        this.elsObject.updateStructure(this);
        this.structureUpdateDone();
    }

    public double eligibleArea() {
        Farm farm = this.getParent();
        return farm.landUse.area;
    }

    public String printSolution() {
        StringBuffer strb = new StringBuffer();
        Farm farm = this.getParent();
        Set<ELSOption> optionsSet = farm.getELSOptionSet();
        double pointsTotal = 0.0;
        for (ELSOption op : optionsSet) {
            if (!this.availableOptions.contains((Object)op.code)) continue;
            double len = op.getSolvedValue();
            strb.append((Object)((Object)op.code) + " " + op.code.description + " " + len + "\n");
            pointsTotal += len * op.pointsPerUnit;
        }
        strb.append("Points Total " + pointsTotal + " of required " + this.elsObject.getPointsRequirement() + "\n");
        strb.append("ELS Subsidy " + this.elsObject.getAnnualSubsidy() * this.elsObject.isInELS() + "\n");
        return strb.toString();
    }

    public final class AcceptanceToELSConstraint
    extends ConstraintBuilder {
        public AcceptanceToELSConstraint() {
            super(ConstraintBuilder.CBType.ELSACCEPT, ModelComponent.MCType.ELSOPTIONS);
        }

        protected void build() {
            Farm farm = ELSOptionsComponent.this.getParent();
            int row = ELSOptionsComponent.this.matrix.numRows();
            MatrixRow rp = new MatrixRow(0.0, 0.0, LPX.LPX_UP, row, "ELSAccept", "ELSAccept");
            ELSOptionsComponent.this.matrix.addRow(rp);
            ++row;
            rp.addElement(new MatrixElement(ELSOptionsComponent.this.elsObject.getDependentColumn(0), ELSOptionsComponent.this.elsObject.getPointsRequirement()));
            Set<ELSOption> optionsSet = farm.getELSOptionSet();
            for (ELSOption op : optionsSet) {
                if (!ELSOptionsComponent.this.availableOptions.contains((Object)op.code)) continue;
                rp.addElement(new MatrixElement(op.getDependentColumn(0), -op.pointsPerUnit));
            }
        }
    }
}

