/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

public class WorkableHoursCalculator {
    private double Lhrday = 9.95;
    private double SD;
    private double FD;
    private double h;
    private double was;
    private double ALPHA;
    private double BETA;
    private double ACCELFNwkhrs;
    private double b1;
    private double b2;
    private double b3;
    private double x;
    private double LTI;
    private double isbeta;
    private double IDONE;
    private double HHH = 0.0;
    private double ds;
    private double df;
    private double Arain;
    private double Asoil;
    private double Ad1;
    private double Ad2;

    public static double workableHours(double Ad1_, double Ad2_, double Asoil_, double Arain_) {
        WorkableHoursCalculator calc = new WorkableHoursCalculator();
        return calc.calculateWorkableHours(Ad1_, Ad2_, Asoil_, Arain_);
    }

    private double calculateWorkableHours(double Ad1_, double Ad2_, double Asoil_, double Arain_) {
        this.Ad1 = Ad1_;
        this.Ad2 = Ad2_;
        this.Asoil = Asoil_;
        this.Arain = Arain_;
        int state = 0;
        block7: while (state >= 0) {
            switch (state) {
                case 0: {
                    state = this.firstBit();
                    continue block7;
                }
                case 1: {
                    state = this.firstLabel();
                    continue block7;
                }
                case 2: {
                    state = this.secondLabel();
                    continue block7;
                }
                case 3: {
                    state = this.thirdLabel();
                    continue block7;
                }
                case 4: {
                    state = this.fourthLabel();
                    continue block7;
                }
            }
            throw new Error("Undefined state");
        }
        return this.ACCELFNwkhrs;
    }

    private int firstBit() {
        this.b1 = 113.0;
        this.b2 = 212.0;
        this.b3 = 365.0;
        this.x = (1.257 - 0.257 * this.Asoil) * (this.Arain * 0.001) + 0.762 * (this.Asoil - 1.0);
        if (this.Arain < 500.0) {
            this.x -= 0.005 * (500.0 - this.Arain);
        }
        this.LTI = 20.6 * this.x * this.x - 89.0 * this.x + 212.0;
        this.isbeta = 0.5075 - 0.00253 * this.LTI;
        if (this.isbeta < 0.01) {
            this.isbeta = 0.01;
        }
        this.IDONE = 0.0;
        this.HHH = 0.0;
        this.ds = this.Ad1 - 0.5;
        if (this.ds > this.b3) {
            this.ds -= this.b3;
        }
        this.df = this.Ad2 - 0.5;
        if (this.df > this.b3) {
            this.df -= this.b3;
        }
        return 1;
    }

    private int firstLabel() {
        if (this.ds < this.b1 - 1.0) {
            return 2;
        }
        if (this.ds < this.b2) {
            return 3;
        }
        this.SD = this.ds - this.b2;
        if (this.df < this.b2) {
            this.FD = this.b3 - 0.5 - this.b2;
            this.ds = 0.5;
        } else {
            this.IDONE = 1.0;
            this.FD = this.df - this.b2;
        }
        this.was = 1.29 * this.LTI - 155.0;
        if (this.SD > this.was) {
            this.BETA = -(9.95 - this.isbeta * this.was / 10.0) / (this.LTI - this.was);
            this.ALPHA = -this.BETA * this.LTI;
        } else {
            this.ALPHA = this.Lhrday;
            this.BETA = -this.isbeta / 10.0;
        }
        return 4;
    }

    private int secondLabel() {
        this.SD = this.ds;
        if (this.df > this.b1) {
            this.FD = this.b1 - 0.5;
            this.ds = this.b1 - 0.5;
        } else {
            this.FD = this.df;
            this.IDONE = 1.0;
        }
        this.BETA = this.isbeta;
        this.ALPHA = this.Lhrday - this.b1 * this.BETA;
        return 4;
    }

    private int thirdLabel() {
        this.SD = this.ds;
        if (this.df < this.b1 - 1.0 || this.df > this.b2 + 1.0) {
            this.FD = this.b2 + 0.5;
            this.ds = this.b2 + 0.5;
        } else {
            this.IDONE = 1.0;
            this.FD = this.df;
        }
        this.BETA = 0.0;
        this.ALPHA = this.Lhrday;
        return 4;
    }

    private int fourthLabel() {
        if (this.ALPHA + this.BETA * this.SD <= 0.0) {
            this.SD = -this.ALPHA / this.BETA;
        }
        if (this.ALPHA + this.BETA * this.FD <= 0.0) {
            this.FD = -this.ALPHA / this.BETA;
        }
        this.h = (this.FD - this.SD) * (this.ALPHA + this.BETA * (this.FD + this.SD) / 2.0);
        if (this.h < 0.0) {
            this.h = 0.0;
        }
        this.HHH += this.h;
        if (this.IDONE == 0.0) {
            return 1;
        }
        this.ACCELFNwkhrs = this.HHH * 0.85;
        return -1;
    }
}

