% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_frequency_quantile.R
\name{compute_frequency_quantile}
\alias{compute_frequency_quantile}
\title{Calculate an annual frequency analysis quantile}
\usage{
compute_frequency_quantile(
  data,
  dates = Date,
  values = Value,
  station_number,
  roll_days = NA,
  roll_align = "right",
  return_period = NA,
  use_max = FALSE,
  use_log = FALSE,
  fit_distr = c("PIII", "weibull"),
  fit_distr_method = ifelse(fit_distr == "PIII", "MOM", "MLE"),
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  ignore_missing = FALSE
)
}
\arguments{
\item{data}{A data frame of flow data that contains columns of events, flow values, and measures (data type).}

\item{dates}{Column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not '
Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Column in \code{data} that contains numeric flow values, in units of cubic metres per second. Default \code{"Value"}.}

\item{station_number}{A character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{roll_days}{Numeric value of the number of days to apply a rolling mean. Required.}

\item{roll_align}{Character string identifying the direction of the rolling mean from the specified date, either by the first 
('left'), last ('right), or middle ('center') day of the rolling n-day group of observations. Default \code{'right'}.}

\item{return_period}{Numeric vector of the estimated time interval, in years, between flow events of a similar size, 
inverse of probability, used to estimate the frequency statistic. Required.}

\item{use_max}{Logical value to indicate using annual maximums rather than the minimums for analysis. Default \code{FALSE}.}

\item{use_log}{Logical value to indicate log-scale transforming of flow data before analysis. Default \code{FALSE}.}

\item{fit_distr}{Character string identifying the distribution to fit annual data, one of "PIII" (Pearson Log III distribution) 
or "weibull" (Weibull distribution). Default \code{"PIII"}.}

\item{fit_distr_method}{Character string identifying the method used to fit the distribution, one of  "MOM" (method of moments) 
or "MLE" (maximum likelihood estimation). Selected as \code{"MOM"} if \code{fit_distr}=="PIII" (default) or \code{"MLE"} if 
 \code{fit_distr}=="weibull".}

\item{water_year_start}{Numeric value indicating the month of the start of the water year for analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank to use the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank to use the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank to include all years.}

\item{months}{Numeric vector of months to include in analysis (e.g.. \code{6:8} for Jun-Aug). Leave blank to summarize 
all months (default \code{1:12}).}

\item{ignore_missing}{Logical value indicating whether dates with missing values should be included in the calculation. If
\code{TRUE} then a statistic will be calculated regardless of missing dates. If \code{FALSE} then only statistics from time periods 
with no missing dates will be returned. Default \code{FALSE}.}
}
\value{
A numeric value of the frequency analysis quantile, given the roll_days and return_period
}
\description{
Performs a volume frequency analysis on annual statistics from a streamflow dataset and calculates a statistic based on
   the provided mean n-days and return period of the statistic, defaults to minimum flows. For example, to determine the 7Q10 of a 
   dataset, set the roll_days to \code{7} and the return_period to \code{10}. Calculates the statistic from all daily discharge 
   values from all years and months, unless specified.Function will calculate using all values in the provided data (no grouped 
   analysis). Analysis methodology replicates that from \href{http://www.hec.usace.army.mil/software/hec-ssp/}{HEC-SSP}.
}
\examples{
\dontrun{

# Working example:

# Compute the annual 7-day flow value with a 1 in 10 year return interval
compute_frequency_quantile(station_number = "08NM116",
                           roll_days = 7,
                           return_period = 10)
                            
}
}
\seealso{
\code{\link{compute_frequency_analysis}}
}
