% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_missing_dates.R
\name{fill_missing_dates}
\alias{fill_missing_dates}
\title{Add rows of missing dates and fill missing flow values with NA}
\usage{
fill_missing_dates(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  water_year_start = 1,
  fill_end_years = TRUE
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{fill_end_years}{Logical value indicating whether to fill incomplete start and end years with rows of dates with NA flow values. 
If \code{FALSE} then only missing dates between the provided start and end dates will be filled. Default \code{TRUE}.}
}
\value{
A tibble data frame of the source data with additional rows of filled values of missing dates.
}
\description{
Adds rows of dates with missing flow values to a streamflow data set with daily flow values of NA. Missing dates will 
   be filled in gaps between data and completely fill the first and last years.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Fill missing dates with NA using calendar years
fill_missing_dates(station_number = "08NM116")

# Fill missing dates with NA using water years starting in August
fill_missing_dates(station_number = "08NM116", 
                   water_year_start = 8)
                   
}
}
