% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qrmls}
\alias{qrmls}
\title{Ordinary least squares for the linear multivariate regression model}
\arguments{
\item{Y}{a matrix of dimension \eqn{(n\times q} response variables.}

\item{X}{an \eqn{(n\times p)} full column rank matrix of predictors.}

\item{X_test}{an \eqn{(q\times p)} full column rank matrix. Test set. By default it set to NULL.}

\item{type}{either "QR" or "R". Specifies the type of decomposition to use: "QR" for the QR decomposition or "R" for the Cholesky factorization of \eqn{A^\top A}. The default is "QR".}
}
\value{
A named list containing \describe{
\item{coeff}{a matrix of dimension \eqn{p\times q} containing the solution for the parameters \eqn{B}.}
\item{fitted}{a matrix of dimension \eqn{n\times q} of fitted values, \eqn{\widehat{Y}=X\widehat{B}}.}
\item{residuals}{a matrix of dimension \eqn{n\times q} of residuals, \eqn{\varepsilon=Y-\widehat{Y}}.}
\item{XTX}{the matrix \eqn{X^\top X}.}
\item{Sigma_hat}{a matrix of dimension \eqn{q\times q} containing the estimated  residual variance-covariance matrix.}
\item{df}{degrees of freedom.}
\item{R}{\eqn{R} matrix of the QR decomposition of the matrix \eqn{X^\top X}.}
\item{XTy}{\eqn{X^\top y}.}
\item{R2}{\eqn{R^2}, coefficient of determination, measure of goodness-of-fit of the model.}
\item{predicted}{predicted values for the test set, \eqn{X_{\text{test}}\widehat{B}}. It is only available if X_test is not NULL.}
\item{PMSE}{}
}
}
\description{
qrmls, or LS for linear multivariate regression models, solves the following optimization problem
\deqn{\textrm{min}_\beta ~ \frac{1}{2}\|Y-XB\|_2^2,}
for \eqn{Y\in\mathbb{R}^{n \times q}} and \eqn{X\in\mathbb{R}^{n\times p}}, to obtain a coefficient matrix \eqn{\widehat{B}\in\mathbb{R}^{p\times q}}. The design matrix \eqn{X\in\mathbb{R}^{n\times p}}
contains the observations for each regressor.
}
\examples{

## generate sample data
set.seed(10)
n         <- 30
p         <- 6
q         <- 3
X         <- matrix(rnorm(n * p, 1), n, p)
X[,1]     <- 1
eps       <- matrix(rnorm(n*q), n, q)
B         <- matrix(0, p, q)
B[,1]     <- rep(1, p)
B[,2]     <- rep(2, p)
B[,3]     <- rep(-1, p)
Y         <- X \%*\% B + eps
X_test    <- matrix(rnorm(5 * p, 1), 5, p)
output    <- fastQR::qrmls(Y = Y, X = X, X_test = X_test, type = "QR")
output$coeff

}
