% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{heliumFootballs}
\alias{heliumFootballs}
\title{Punting helium- and air-filled footballs}
\format{A data frame with 39 observations on the following 3 variables.
\itemize{ \item{Trial}{ trial number} \item{Air}{ distance
traveled by air-filled football (yards)} \item{Helium}{ distance
traveled by helium-filled football (yards)} }}
\source{
These data are available from DASL, the data and story library
(\url{http://lib.stat.cmu.edu/DASL/}).
}
\description{
Two identical footballs, one air-filled and one helium-filled, were used
outdoors on a windless day at The Ohio State University's athletic complex.
Each football was kicked 39 times and the two footballs were alternated with
each kick. The experimenter recorded the distance traveled by each ball.
}
\examples{
data(heliumFootballs)
xyplot(Helium~Air, data=heliumFootballs)
bwplot(~(Helium-Air), data=heliumFootballs)
}
\references{
Lafferty, M. B. (1993), "OSU scientists get a kick out of sports
controversy", \emph{The Columbus Dispatch} (November, 21, 1993), B7.
}
\keyword{datasets}

