% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_multinom_model.R
\name{fit_multinom_model}
\alias{fit_multinom_model}
\title{Fit Simple Multinomial Model}
\usage{
fit_multinom_model(cluster, X, verbose = c("none", "detailed"), ...)
}
\arguments{
\item{cluster}{A factor specifying a grouping, or clustering, of
the rows of \code{X}; e.g., the \dQuote{cluster} output from
\code{\link[stats]{kmeans}}.}

\item{X}{The n x m matrix of counts; all entries of X should be
non-negative. It can be a sparse matrix (class \code{"dgCMatrix"})
or dense matrix (class \code{"matrix"}), with some exceptions (see
\sQuote{Details}).}

\item{verbose}{This is passed as the \dQuote{verbose} argument in
the call to \code{\link{init_poisson_nmf}}.}

\item{\dots}{Additional arguments passed to
\code{\link{init_poisson_nmf}}.}
}
\value{
A multinomial topic model fit.
}
\description{
Fit a simple multinomial model for count data, in
  which each sample (\emph{i.e.}, a row of the data matrix \code{X})
  is assigned to a cluster. Under this simple multinomial model,
  \eqn{x_{ij}} assigned to cluster \eqn{k} is multinomial with sample
  size \eqn{s_i = x_{i1} + ... + x_{im}} and multinomial
  probabilities \eqn{p_{1k}, ..., p_{mk}}. This is a special case of
  the multinomial topic model in which all the mixture proportions
  are either 0 or 1. The maximum-likelihood estimates (MLEs) of the
  multinomial probabilities have a closed-form solution; no
  iterative algorithm is needed to fit this simple model.
}
\seealso{
\code{\link{fit_topic_model}}
}
