% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaggle_wrappers.R
\name{competition_download_file}
\alias{competition_download_file}
\title{Competition download file}
\usage{
competition_download_file(
  competition,
  file_name,
  path = NULL,
  force = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{competition}{the name of the competition}

\item{file_name}{the configuration file name}

\item{path}{a path to download the file to}

\item{force}{force the download if the file already exists (default FALSE)}

\item{quiet}{suppress verbose output (default is FALSE)}
}
\value{
None
}
\description{
download a competition file to a designated location, or use
}
\examples{

\dontrun{

com_nm = 'titanic'

titanic_files = competition_list_files(com_nm)
titanic_files = lapply(1:length(titanic_files),
                      function(x) as.character(titanic_files[[x]]))

str(titanic_files)

if(!dir.exists(com_nm)) {
 dir.create(com_nm)
}

# download via api
competition_download_files(competition = com_nm, path = com_nm, unzip = TRUE)

}
}
