% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers.R
\name{weight_decay}
\alias{weight_decay}
\title{Weight_decay}
\usage{
weight_decay(p, lr, wd, do_wd = TRUE, ...)
}
\arguments{
\item{p}{p}

\item{lr}{learning rate}

\item{wd}{weight decay}

\item{do_wd}{do_wd}

\item{...}{additional args to pass}
}
\value{
None
}
\description{
Weight decay as decaying `p` with `lr*wd`
}
\examples{

\dontrun{

tst_param = function(val, grad = NULL) {
  "Create a tensor with `val` and a gradient of `grad` for testing"
  res = tensor(val) \%>\% float()

  if(is.null(grad)) {
    grad = tensor(val / 10)
  } else {
    grad = tensor(grad)
  }

  res$grad = grad \%>\% float()
  res
}
p = tst_param(1., 0.1)
weight_decay(p, 1., 0.1)

}

}
