% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationFind.r
\name{.locationFind,missing-method}
\alias{.locationFind,missing-method}
\alias{.locationFind,GLocation-method}
\alias{.locationFind,SpatRaster-method}
\alias{.locationFind,SpatVector-method}
\alias{.locationFind,sf-method}
\alias{.locationFind,character-method}
\title{Match CRS of a GSpatial object and an existing "GRASS" location}
\usage{
\S4method{.locationFind}{missing}(x, return = "name")

\S4method{.locationFind}{GLocation}(x, return = "name", match = "name")

\S4method{.locationFind}{SpatRaster}(x, return = "name", match = "name")

\S4method{.locationFind}{SpatVector}(x, return = "name", match = "name")

\S4method{.locationFind}{sf}(x, return = "name", match = "name")

\S4method{.locationFind}{character}(x, return = "name", match = "name")
}
\arguments{
\item{x}{Either:
\itemize{
\item Missing: Returns names and coordinate reference system strings of all "locations".
\item A character representing a coordinate reference system in WKT format
\item A \code{SpatRaster}, \code{SpatVector}, or \code{sf} vector with a coordinate reference system
\item A \code{GSpatial} object (usually a \code{GRaster} or \code{GVector})
}}

\item{return}{Either:
\itemize{
\item \code{"name"} (default): Returns the name of the "location" with a coordinate reference system the same as \code{x}.
\item \code{"index"}: Returns the index of this "location" in \code{.fasterRaster$locations} of the \code{.fasterRaster} environment.
\item \code{"crs"}: Returns the coordinate reference system of this "project/location".
}}

\item{match}{Character: Method used to find the location. If \code{match} is "\code{name}"" (default), then the name of the location is used. If \code{match} is "\code{crs}", then the coordinate reference system of each location is checked for a match.}
}
\value{
Character, integer, or \code{NULL} (if no match is found).
}
\description{
The function searches the set of available \strong{GRASS} "projects" (previously known as "locations") for one that has a coordinate reference system matching a \code{GSpatial} object. If none are found, or if no connection with \strong{GRASS} has yet been made, then it returns \code{NULL}. Otherwise, it returns either the index or the name of the matching location.
}
\keyword{internal}
