% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastml.R
\name{fastml}
\alias{fastml}
\title{Fast Machine Learning Function}
\usage{
fastml(
  data = NULL,
  train_data = NULL,
  test_data = NULL,
  label,
  algorithms = "all",
  task = "auto",
  test_size = 0.2,
  resampling_method = "cv",
  folds = ifelse(grepl("cv", resampling_method), 10, 25),
  repeats = ifelse(resampling_method == "repeatedcv", 1, NA),
  event_class = "first",
  exclude = NULL,
  recipe = NULL,
  tune_params = NULL,
  metric = NULL,
  algorithm_engines = NULL,
  n_cores = 1,
  stratify = TRUE,
  impute_method = "error",
  impute_custom_function = NULL,
  encode_categoricals = TRUE,
  scaling_methods = c("center", "scale"),
  balance_method = c("none", "upsample", "downsample"),
  resamples = NULL,
  summaryFunction = NULL,
  use_default_tuning = FALSE,
  tuning_strategy = "grid",
  tuning_iterations = 10,
  early_stopping = FALSE,
  adaptive = FALSE,
  learning_curve = FALSE,
  seed = 123,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data frame containing the complete dataset. If both `train_data` and `test_data` are `NULL`, `fastml()` will split this into training and testing sets according to `test_size` and `stratify`. Defaults to `NULL`.}

\item{train_data}{A data frame pre-split for model training. If provided, `test_data` must also be supplied, and no internal splitting will occur. Defaults to `NULL`.}

\item{test_data}{A data frame pre-split for model evaluation. If provided, `train_data` must also be supplied, and no internal splitting will occur. Defaults to `NULL`.}

\item{label}{A string specifying the name of the target variable.}

\item{algorithms}{A vector of algorithm names to use. Default is \code{"all"} to run all supported algorithms.}

\item{task}{Character string specifying model type selection. Use "auto" to let the function detect whether the target is for classification or regression based on the data, or explicitly set to "classification" or "regression".}

\item{test_size}{A numeric value between 0 and 1 indicating the proportion of the data to use for testing. Default is \code{0.2}.}

\item{resampling_method}{A string specifying the resampling method for model evaluation. Default is \code{"cv"} (cross-validation).
Other options include \code{"none"}, \code{"boot"}, \code{"repeatedcv"}, etc.}

\item{folds}{An integer specifying the number of folds for cross-validation. Default is \code{10} for methods containing "cv" and \code{25} otherwise.}

\item{repeats}{Number of times to repeat cross-validation (only applicable for methods like "repeatedcv").}

\item{event_class}{A single string. Either "first" or "second" to specify which level of truth to consider as the "event". Default is "first".}

\item{exclude}{A character vector specifying the names of the columns to be excluded from the training process.}

\item{recipe}{A user-defined \code{recipe} object for custom preprocessing. If provided, internal recipe steps (imputation, encoding, scaling) are skipped.}

\item{tune_params}{A named list of tuning ranges for each algorithm and engine
pair. Example: \code{list(rand_forest = list(ranger = list(mtry = c(1, 3))))}
will override the defaults for the ranger engine. Default is \code{NULL}.}

\item{metric}{The performance metric to optimize during training.}

\item{algorithm_engines}{A named list specifying the engine to use for each algorithm.}

\item{n_cores}{An integer specifying the number of CPU cores to use for parallel processing. Default is \code{1}.}

\item{stratify}{Logical indicating whether to use stratified sampling when splitting the data. Default is \code{TRUE} for classification and \code{FALSE} for regression.}

\item{impute_method}{Method for handling missing values. Options include:
\describe{
  \item{\code{"medianImpute"}}{Impute missing values using median imputation (recipe-based).}
  \item{\code{"knnImpute"}}{Impute missing values using k-nearest neighbors (recipe-based).}
  \item{\code{"bagImpute"}}{Impute missing values using bagging (recipe-based).}
  \item{\code{"remove"}}{Remove rows with missing values from the data (recipe-based).}
  \item{\code{"mice"}}{Impute missing values using MICE (Multiple Imputation by Chained Equations).}
  \item{\code{"missForest"}}{Impute missing values using the missForest algorithm.}
  \item{\code{"custom"}}{Use a user-provided imputation function (see `impute_custom_function`).}
  \item{\code{"error"}}{Do not perform imputation; if missing values are detected, stop execution with an error.}
  \item{\code{NULL}}{Equivalent to \code{"error"}. No imputation is performed, and the function will stop if missing values are present.}
}
Default is \code{"error"}.}

\item{impute_custom_function}{A function that takes a data.frame as input and returns an imputed data.frame. Used only if \code{impute_method = "custom"}.}

\item{encode_categoricals}{Logical indicating whether to encode categorical variables. Default is \code{TRUE}.}

\item{scaling_methods}{Vector of scaling methods to apply. Default is \code{c("center", "scale")}.}

\item{balance_method}{Method to handle class imbalance. One of \code{"none"},
\code{"upsample"}, or \code{"downsample"}. Applied to the training set for
classification tasks. Default is \code{"none"}.}

\item{resamples}{Optional rsample object providing custom resampling splits.
If supplied, \code{resampling_method}, \code{folds}, and \code{repeats} are
ignored.}

\item{summaryFunction}{A custom summary function for model evaluation. Default is \code{NULL}.}

\item{use_default_tuning}{Logical; if \code{TRUE} and \code{tune_params} is \code{NULL}, tuning is performed using default grids. Tuning also occurs when custom \code{tune_params} are supplied. When \code{FALSE} and no custom parameters are given, models are fitted once with default settings. Default is \code{FALSE}.}

\item{tuning_strategy}{A string specifying the tuning strategy. Must be one of
\code{"grid"}, \code{"bayes"}, or \code{"none"}. Default is \code{"grid"}.
If custom \code{tune_params} are provided while \code{tuning_strategy = "none"},
they will be ignored with a warning.}

\item{tuning_iterations}{Number of iterations for Bayesian tuning. Ignored when
\code{tuning_strategy} is not \code{"bayes"}. Validation of this argument only
occurs for the Bayesian strategy. Default is \code{10}.}

\item{early_stopping}{Logical indicating whether to use early stopping in Bayesian tuning methods (if supported). Default is \code{FALSE}.}

\item{adaptive}{Logical indicating whether to use adaptive/racing methods for tuning. Default is \code{FALSE}.}

\item{learning_curve}{Logical. If TRUE, generate learning curves (performance vs. training size).}

\item{seed}{An integer value specifying the random seed for reproducibility.}

\item{verbose}{Logical; if TRUE, prints progress messages during the training
and evaluation process.}
}
\value{
An object of class \code{fastml} containing the best model, performance metrics, and other information.
}
\description{
Trains and evaluates multiple classification or regression models automatically detecting the task based on the target variable type.
}
\details{
Fast Machine Learning Function

Trains and evaluates multiple classification or regression models. The function automatically
detects the task based on the target variable type and can perform advanced hyperparameter tuning
using various tuning strategies.
}
\examples{
\donttest{
# Example 1: Using the iris dataset for binary classification (excluding 'setosa')
data(iris)
iris <- iris[iris$Species != "setosa", ]  # Binary classification
iris$Species <- factor(iris$Species)

# Define a custom tuning grid for the ranger engine
tune <- list(
  rand_forest = list(
    ranger = list(mtry = c(1, 3))
  )
)

# Train models with custom tuning
model <- fastml(
  data = iris,
  label = "Species",
  algorithms = "rand_forest",
  tune_params = tune,
  use_default_tuning = TRUE
)

# View model summary
summary(model)


  }

}
