% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection_helpers.R
\name{flatten_and_rename_models}
\alias{flatten_and_rename_models}
\title{Flatten and Rename Models}
\usage{
flatten_and_rename_models(models)
}
\arguments{
\item{models}{A nested list of models. The outer list should have names. If an inner element is a named list, the names will be combined with the outer name in the format \code{"outer_name (inner_name)"}.}
}
\value{
A flattened list with each element renamed according to its original outer and inner list names.
}
\description{
Flattens a nested list of models and renames the elements by combining the outer and inner list names.
}
\details{
The function iterates over each element of the outer list. For each element, if it is a list with names, the function concatenates the outer list name and the inner names using \code{paste0} and \code{setNames}. If an element is not a list or does not have names, it is included in the result without modification.
}
