% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from.igraph.R
\name{from.igraph}
\alias{from.igraph}
\title{Transform an \code{igraph} object to a \code{fastnet} object}
\usage{
from.igraph(net.igraph)
}
\arguments{
\item{net.igraph}{The input \code{igraph} object.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Transform an \code{igraph} object to an ego-centric list form used in \code{fastnet}.
}
\examples{
\dontrun{
library("igraph")
net.igraph <- erdos.renyi.game(100,0.1)
g <- from.igraph(net.igraph)}
}
\author{
Xu Dong.
}
