% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_consecutive_id.R
\name{f_consecutive_id}
\alias{f_consecutive_id}
\title{Consecutive IDs}
\usage{
f_consecutive_id(x)
}
\arguments{
\item{x}{A vector or data frame.}
}
\value{
An integer vector of consecutive run IDs in the range \verb{[1, n + 1)}.
}
\description{
\code{f_consecutive_id()}, an alternative to \code{dplyr::consecutive_id()}
creates an integer vector with values in the range \verb{[1, n + 1)} where
\code{n} is the length of the vector or number of rows of the data frame.
The ID increments every time \code{x[i] != x[i - 1]} thus giving information on
when there is a change in value.
}
\details{
'ALTREP' compact sequences are supported as well.

To mimic \code{dplyr::consecutive_id()} where multiple variables are selected,
just use \code{dplyr::pick()}.

\code{f_consecutive_id} has a smaller overhead and thus should be faster when
called many times, e.g. when using a \code{grouped_df} with many groups.
}
