% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_labels}
\alias{get_labels}
\title{Get list of labels (supervised model)}
\usage{
get_labels(model)
}
\arguments{
\item{model}{trained fastText model}
}
\value{
\link{character} containing each label
}
\description{
Get a \link{character} containing each label seen during training.
}
\examples{

library(fastrtext)
model_test_path <- system.file("extdata", "model_classification_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
print(head(get_labels(model), 5))

}
