% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{build_vectors}
\alias{build_vectors}
\title{Build fasttext vectors}
\usage{
build_vectors(documents, model_path, modeltype = c("skipgram", "cbow"),
  bucket = 2e+06, dim = 100, epoch = 5, label = "__label__",
  loss = c("ns", "hs", "softmax"), lr = 0.05, lrUpdateRate = 100,
  maxn = 6, minCount = 5, minn = 3, neg = 5, t = 1e-04,
  thread = 12, verbose = 2, wordNgrams = 1, ws = 5)
}
\arguments{
\item{documents}{character vector of documents used for training}

\item{model_path}{Name of output file \emph{without} file extension.}

\item{modeltype}{Should training be done using skipgram or cbow? Defaults to skipgram.}

\item{bucket}{number of buckets}

\item{dim}{size of word vectors}

\item{epoch}{number of epochs}

\item{label}{text string, labels prefix. Default is "\strong{label}"}

\item{loss}{loss function {ns, hs, softmax}}

\item{lr}{learning rate}

\item{lrUpdateRate}{change the rate of updates for the learning rate}

\item{maxn}{max length of char ngram}

\item{minCount}{minimal number of word occurences}

\item{minn}{min length of char ngram}

\item{neg}{number of negatives sampled}

\item{t}{sampling threshold}

\item{thread}{number of threads}

\item{verbose}{verbosity level}

\item{wordNgrams}{max length of word ngram}

\item{ws}{size of the context window}
}
\value{
path to model file, as character
}
\description{
Trains a fasttext vector/unsupervised model following method described in
\href{https://arxiv.org/abs/1607.04606}{Enriching Word Vectors with Subword Information}
using the \href{https://fasttext.cc/}{fasttext} implementation.

See \href{https://fasttext.cc/docs/en/unsupervised-tutorial.html}{FastText word representation tutorial} for more information on
training unsupervised models using fasttext.
}
\examples{
\dontrun{
library(fastrtext)
text <- train_sentences
model_file <- build_vectors(text[['text']], 'my_model')
model <- load_model(model_file)
}
}
