% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_word_ids}
\alias{get_word_ids}
\title{Retrieve word IDs}
\usage{
get_word_ids(model, words)
}
\arguments{
\item{model}{\code{fastText} model}

\item{words}{\link{character} containing words to retrieve IDs}
}
\value{
\link{numeric} of ids
}
\description{
Get ID of words in the dictionary
}
\examples{
library(fastrtext)
model_test_path <- system.file("extdata", "model_unsupervised_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
ids <- get_word_ids(model, c("this", "is", "a", "test"))

# print positions
print(ids)
# retrieve words in the dictionary using the positions retrieved
print(get_dictionary(model)[ids])
}
