% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_word_vectors}
\alias{get_word_vectors}
\title{Get word embeddings}
\usage{
get_word_vectors(model, words = get_dictionary(model))
}
\arguments{
\item{model}{trained \code{fastText} model}

\item{words}{\link{character} of words. Default: return every word from the dictionary.}
}
\value{
\link{matrix} containing each word embedding as a row and \code{rownames} are populated with word strings.
}
\description{
Return the vector representation of provided words (unsupervised training)
or provided labels (supervised training).
}
\examples{

library(fastrtext)
model_test_path <- system.file("extdata", "model_unsupervised_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
get_word_vectors(model, c("introduction", "we"))

}
