% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{fct_factorize}
\alias{fct_factorize}
\title{Factorize Character Vectors with Consistent Levels}
\usage{
fct_factorize(..., levels = NULL)
}
\arguments{
\item{...}{Character vectors to factorize.}

\item{levels}{An optional character vector specifying the levels. If \code{NULL}, levels are determined from the combined unique values of all vectors.}
}
\value{
A list of factor vectors with consistent levels.
}
\description{
Converts one or more character vectors into factors, ensuring that they share the same levels.
}
\examples{
# Example character vectors
vec1 <- c('apple', 'banana', 'cherry')
vec2 <- c('banana', 'date', 'apple')

# Factorize with consistent levels
factors <- fct_factorize(vec1, vec2)
levels(factors[[1]])
levels(factors[[2]])
}
\author{
Kai Guo
}
