% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{fct_reorder_within}
\alias{fct_reorder_within}
\title{Reorder Factor Levels Within Groups}
\usage{
fct_reorder_within(factor_vec, group_vec, by, fun = mean, decreasing = FALSE)
}
\arguments{
\item{factor_vec}{A factor vector to be reordered.}

\item{group_vec}{A factor vector defining the groups.}

\item{by}{A numeric vector to order by.}

\item{fun}{A function to summarize within groups (e.g., mean, median).}

\item{decreasing}{Logical. Should the ordering be decreasing? Default is \code{FALSE}.}
}
\value{
A factor vector with levels reordered within groups.
}
\description{
Reorders the levels of a factor vector within groups defined by another factor vector.
}
\examples{
# Example data
data <- data.frame(
  item = factor(c('A', 'B', 'C', 'D', 'E', 'F')),
  group = factor(c('G1', 'G1', 'G1', 'G2', 'G2', 'G2')),
  value = c(10, 15, 5, 20, 25, 15)
)
data <- rbind(data, data)
# Reorder 'item' within 'group' by 'value'
data$item <- fct_reorder_within(data$item, data$group, data$value, mean)
}
\author{
Kai Guo
}
